<?php

// https://labs.aweber.com/docs/code_samples/auth/dist_authorization

class digimember_AutoresponderHandler_PluginMailchimp extends digimember_AutoresponderHandler_PluginBase
{

    public function unsubscribe( $email )
    {
    }

    public function getPersonalData( $email )
    {
        return array();
    }

    /**
     * @param       $email
     * @param       $first_name
     * @param       $last_name
     * @param       $product_id
     * @param       $order_id
     * @param bool  $force_double_optin
     * @param array $custom_fields
     * @throws Exception
     */
    public function subscribe( $email, $first_name, $last_name, $product_id, $order_id, $force_double_optin=true, $custom_fields=array() )
    {
        $mailchimp = $this->mailchimp();

        $use_dbl_optin = $this->data( 'use_dbl_optin', 'no' ) == 'yes' || $force_double_optin;

        $list_id = $this->data( 'list_id' );
        if (!$list_id)
        {
            return;
        }

        $mailchimp->listSubscribe( $list_id, $email, $first_name, $last_name, $use_dbl_optin, $custom_fields );

        if ($mailchimp->errorCode){
            throw new Exception( $mailchimp->errorMessage );
        }
    }

    public function formMetas()
    {
        $metas = array();

        $metas[] = array(
                'name' => 'apikey',
                'type' => 'text',
                'size' => 36,
                'label' => _digi3( 'MailChimp API key' ),
                'rules' => 'required|trim|remove_whitespace',
                'class' => 'ncore_code',
        );

        $shortcode = 'ncore_signup';

        $metas[] = array(
                'name' => 'use_dbl_optin',
                'type' => 'select',
                'options' => array( 'no' => _ncore('No' ), 'yes' => _ncore('Yes' ) ),
                'label' => _digi3('Use double-opt-in' ),
                'default' => 'no',
                'tooltip' => _digi3('This option applies only to sales (where the customer pays money).|For free sign ups (using the shortcode %s), a double-opt-in is always used.', $shortcode ),
            );



        $list_options = $this->getLists();
        $list_error = $list_options === 'error';;
        $have_lists = $list_options && !$list_error;
        if ($have_lists)
        {
            $metas[] = array(
                'name' => 'list_id',
                'type' => 'select',
                'options' => $list_options,
                'label' => _digi3( 'MailChimp list' ),
                'rules' => 'required|trim',
            );
        }
        else
        {
            $metas[] = array(
                'name' => 'list_id',
                'type' => 'hidden',
            );

            $msg = $list_error
                 ? _digi3( 'Enter a valid API key above, save and then pick a MailChimp list here.' )
                 : _digi3( 'Please log into your MailChimp account and create an email list.' );


            $css = '';

            $show_error = $list_error && (bool) $this->apiKey();

            if ($show_error)
            {
                $css = 'ncore_form_cell_error_message';
                $msg = _digi3( 'The API key is invalid.' ) . ' ' . $msg;
            }

            $metas[] = array(
                'label' => _digi3( 'MailChimp list' ),
                'type' => 'html',
                'html' => $msg,
                'css'  => $css,
            );
        }


        return $metas;
    }

    public function instructions()
    {
        $instructions = parent::instructions();

        $instructions[] = _digi3( '<strong>In MailChimp</strong> click on your name on the top right of the screen.' ) . ' ' . _digi3( 'Select %s.', '<em>Account</em>' );

        $instructions[] = _digi3( 'Select %s.', '<em>Extras - API Keys</em>' );

        $instructions[] = _digi3( 'Click on %s.', '<em>Create A Key</em>' );

        $instructions[] = _digi3( 'In the column %s click on the API key and copy it to the clipboard.', '<em>API Key</em>' );

        $instructions[] = _digi3( 'Optional: In the column %s click on %s and enter %s.', '<em>Label</em>', '<em>none set</em>', '"DigiMember"' );

        $instructions[] = _digi3( '<strong>In DigiMember</strong> paste the API key into the text input %s.', '<em>MailChimp API Key</em>' );

        $instructions[] = _digi3( 'Save your changes.' );

        return $instructions;
    }

    /**
     * @var Digimember_Mailchimp_Helper
     */
    private $mailchimp;

    /**
     * @return Digimember_Mailchimp_Helper
     * @throws Exception
     */
    private function mailchimp()
    {
        if (isset($this->mailchimp))
        {
            if (!$this->mailchimp)
            {
                throw new Exception( $this->unauthMsg() );
            }

            return $this->mailchimp;
        }

        require_once 'helper/mailchimp.php';

        $apikey = $this->apiKey();

        if (!$apikey)
        {
            throw new Exception( _digi3( 'You need to enter a valid MailChimp API key.' ) );
        }

        $this->mailchimp = new Digimember_Mailchimp_Helper($apikey);

        if ($this->mailchimp->errorCode)
        {
            throw new Exception( $this->mailchimp->errorMessage );
        }

        return $this->mailchimp;

    }

    private function getLists()
    {
        if (!$this->isConntected())
        {
            return 'error';
        }

        try
        {
            $mailchimp = $this->mailchimp();

            $retval = $mailchimp->lists();
            if ($mailchimp->errorCode)
            {
                return 'error';
            }

            if (empty($retval['lists'])) {
                return 'error';
            }

            $lists = $retval['lists'];

            $options = array();
            $options[ "" ] = _ncore( '(Please select ...)' );

            foreach ($lists as $one)
            {
                $options[ $one['id'] ] = $one['name'];
            }

            $this->api->load->helper( 'array' );
            return ncore_sortOptions( $options );
        }

        catch (Exception $e)
        {
            return 'error';
        }
    }

    private function isConntected()
    {
        try
        {
            if (!$this->apiKey())
            {
                return false;
            }

            $this->mailchimp();

            return true;
        }

        catch (Exception $e)
        {
            return false;
        }
    }

    private function unauthMsg()
    {
        return _digi3( 'The MailChimp API key is invalid. Please enter a valid API key.' );
    }

    private function apiKey()
    {
        return trim( $this->data( 'apikey' ) );
    }
}
