<?php
require_once dirname(__FILE__) . '/helper/StripeResponseParser.php';

/**
 * Class digimember_PaymentHandler_PluginStripe
 */
class digimember_PaymentHandler_PluginStripe extends digimember_PaymentHandler_PluginBase
{
    /** @var string|StripeResponse */
    private $stripeResponse;

    /**
     * @param $variableName
     * @return mixed
     * @throws Exception
     */
    private function getParamFromResponse($variableName)
    {
        if (is_null($this->stripeResponse)) {
            $input = file_get_contents('php://input');
            $jsonArgs = json_decode($input, true);
            $inputArgs = [];
            if (is_array($jsonArgs)) {
                $this->api->load->helper('array');
                ncore_flattenAssocArray($jsonArgs, $inputArgs);
            }
            $parser = new StripeResponseParser(
                $this->data('secret_key'),
                $this->data('mapping_type'),
                $this->data('metadata_key'),
                $this->data('manual_product_id')
            );
            $this->stripeResponse = $parser->parseRawResponse($inputArgs);
        }

        if ($this->stripeResponse instanceof StripeResponse) {
            return ncore_retrieve($this->stripeResponse, $variableName);
        }

        $this->exception($this->stripeResponse);
        return null;
    }

    /**
     * @param string $variable_name
     * @param bool   $required
     * @param bool   $array_allowed
     * @param bool   $do_split_mapped_and_unmapped_value
     * @return array|bool|mixed
     * @throws Exception
     */
    public function getParam($variable_name, $required = false, $array_allowed = false, $do_split_mapped_and_unmapped_value = false)
    {
        $value = $this->getParamFromResponse($variable_name);
        if ($variable_name == 'product_code') {
            switch ($this->data('mapping_type')) {
                case STRIPE_MAPPING_MANUAL:
                    $product_code = $value;
                    break;
                default:
                    $product_code = is_array($value) ? array_map(function($value) {
                        return ncore_retrieve($this->productCodeMap(), $value);
                    }, $value) : ncore_retrieve($this->productCodeMap(), $value);
            }
            return is_array($product_code) ? [$product_code, []] : [[$product_code], []];
        }
        return $value;
    }

    /**
     * @return array
     */
    protected function methods()
    {
        return [METHOD_INPUT_JSON];
    }

    /**
     * @return array
     */
    public function formMetas()
    {
        return [

            // INSTRUCTIONS

            // Instructions for Product identification method "Order/Product"
            [
                'name' => 'order_product_instructions',
                'type' => 'html',
                'html' => '
<ol>
    <li>' . _digi3('<b>Here in DigiMember </b> click on <i>Save changes </i> below to create a notification URL. </li>') . '
    <li>' . _digi3('Copy the notification URL.') . '</li> 
    <li>' . _digi3('Select your desired product identification method.') . '</li> 
    <li>' . _digi3('Switch to <b>Stripe</b>. If you don’t have an account already create one and activate it.') . '</li> 
    <li>' . _digi3('Go to <i>Developers > Webhooks </i> and create a webhook with the copied notification URL. Select only ‘charge.refunded’, ‘charge.succeeded’ and ‘charge.failed’ as event types for this webhook.') . '</li> 
    <li>' . _digi3('Go to <i>Developers > API keys </i> and copy your Stripe secret key. Paste the secret key here <b> in DigiMember </b>into the input field below.') . '</li>
    <li>' . _digi3(' <b>In Stripe</b> go to <i>Orders > Products</i> and create a matching product in Stripe for each product you want to sell with DigiMember. Create at least one SKU for each product.') . '</li>
    <li>' . _digi3('Copy the generated product SKUs and paste them here <b>in DigiMember </b>below.') . '</li>
    <li>' . _digi3('Save your changes.') . '</li>
</ol>',

                'label' => _digi3('Instructions'),
                'depends_on' => [
                    'stripe_mapping_type' => 'order_product',
                ],
            ],

            // Instructions for Product identification method "Metadata"
            [
                'name' => 'metadata_instructions',
                'type' => 'html',
                'html' => '
<ol>
    <li> ' . _digi3('<b>Here in DigiMember </b> click on <i>Save changes </i> below to create a notification URL.') . '</li> 
    <li> ' . _digi3('Copy the notification URL.') . '</li> 
    <li> ' . _digi3('Select your desired product identification method.') . '</li> 
    <li>' . _digi3('Switch to <b>Stripe</b>. If you don’t have an account already create one and activate it.') . '</li>  
    <li> ' . _digi3('Go to <i>Developers > Webhooks </i> and create a webhook with the copied notification URL. Select only ‘charge.refunded’, ‘charge.succeeded’ and ‘charge.failed’ as event types for this webhook.') . '</li> 
    <li> ' . _digi3('Go to <i>Developers > API keys </i> and copy your Stripe secret key. Paste the secret key here <b> in DigiMember </b>into the input field below.') . '</li>
    <li> ' . _digi3('Enter the key with which you want to identify your products in the <i>Metadata key </i>field below.') . '</li>
    <li> ' . _digi3('Enter the matching values for each product in the <i>Stripe product Ids</i> fields. Multiple values need to be separated by commas.') . '</li> 
    <li> ' . _digi3('Save your changes.') . '</li>
</ol>',

                'label' => _digi3('Instructions'),
                'depends_on' => [
                    'stripe_mapping_type' => 'metadata',
                ],
            ],

            // Instructions for Product identification method "Manual"
            [
                'name' => 'manual_instructions',
                'type' => 'html',
                'html' => '
<ol>
    <li> ' . _digi3('<b>Here in DigiMember </b> click on <i>Save changes </i> below to create a notification URL.') . '</li> 
    <li> ' . _digi3('Copy the notification URL.') . '</li> 
    <li> ' . _digi3('Select your desired product identification method.') . '</li> 
    <li>' . _digi3('Switch to <b>Stripe</b>. If you don’t have an account already create one and activate it.') . '</li>  
    <li> ' . _digi3('Go to <i>Developers > Webhooks </i> and create a webhook with the copied notification URL. Select only ‘charge.refunded’, ‘charge.succeeded’ and ‘charge.failed’ as event types for this webhook.') . '</li> 
    <li> ' . _digi3('Go to <i>Developers > API keys </i> and copy your Stripe secret key. Paste the secret key here <b> in DigiMember </b>into the input field below.') . '</li>
    <li> ' . _digi3(' Select the product you want to assign to any charge.') . '</li> 
    <li> ' . _digi3('Save your changes.') . '</li>
</ol>',
                'label' => _digi3('Instructions'),
                'depends_on' => [
                    'stripe_mapping_type' => 'manual',
                ],
            ],

            [
                'name' => 'mapping_type',
                'type' => 'select',
                'label' => _digi3('Product identification method'),
                'value' => $this->data('mapping_type'),
                'options' => [
//                    'order_product' => _digi3('Order / Product'),
                    'metadata' => _digi3('Metadata'),
                    'manual' => _digi3('Manual'),
                ],
            ],
            [
                'name' => 'metadata_key',
                'type' => 'text',
                'value' => $this->data('metadata_key', 'product_id'),
                'label' => _digi3('Metadata key'),
                'rules' => 'required',
                'depends_on' => [
                    'stripe_mapping_type' => 'metadata',
                ],
            ],
            [
                'name' => 'manual_product_id',
                'type' => 'select',
                'value' => $this->data('manual_product_id'),
                'options' => $this->productOptions(),
                'label' => _digi3('Assign product to any charge'),
                'rules' => 'required',
                'depends_on' => [
                    'stripe_mapping_type' => 'manual',
                ],
            ],
            [
                'name' => 'product_code_map',
                'type' => 'map',
                'label' => _digi3('%s product SKUs', 'Stripe'),
                'array' => $this->productOptions(),
                'hint' => _digi3('Separate multiple product SKUs by commas.'),
                'depends_on' => [
                    'stripe_mapping_type' => ['metadata', 'order_product'],
                ],
            ],
            [
                'name' => 'secret_key',
                'type' => 'text',
                'value' => $this->data('secret_key'),
                'label' => _digi3('Stripe secret key'),
                'hint' => _digi3('Depending on your usage of Stripe, you should provide your API key, so DigiMember can acquire your customers data for a wider variety of cases.'),
            ],

        ];
    }

    /**
     * @return array
     */
    protected function parameterNameMap()
    {
        return [
            // Stripe => DigiMember
            'type' => 'type',
            'product_code' => 'product_code',
            'order_id' => 'order_id',
            'email' => 'email',
            'first_name' => 'first_name',
            'street' => 'street',
            'zip_code' => 'zip_code',
            'state' => 'state',
            'city' => 'city',
            'country' => 'country',
        ];
    }

    /**
     * @return array
     */
    protected function eventMap()
    {
        return [
            'charge.succeeded' => EVENT_SALE,
            'charge.refunded' => EVENT_REFUND,
            'charge.failed' => EVENT_MISSED_PAYMENT,

            'charge.dispute.created' => EVENT_MISSED_PAYMENT,
            'charge.dispute.funds_reinstated' => EVENT_SALE,
            'charge.dispute.funds_withdrawn' => EVENT_REFUND,
        ];
    }

    /**
     * @return array
     */
    public function instructions()
    {
        $instructions = parent::instructions();

//        $instructions[] = _digi3('Locate the notification URL below and copy it to the clipboard.');
//        $instructions[] = _digi3('Open the Cleverbrigde\'s %s.', '<strong>Commerce Assistant</strong>');
//        $instructions[] = _digi3('In the left column, the box %s. Click on %s', '<em>Channel Management</em>', '<em>Product lists</em>');
//        $instructions[] = _digi3('Create a new product list (type: %s) and add all products %s will handle.', 'Include List', $this->api->pluginDisplayName());
//        $instructions[] = _digi3('In the main menu, select %s. Then open the tab %s.', '<em>Administration - Edit Account</em>', '<em>Notification</em>');
//        $instructions[] = _digi3('Click on %s and enter these settings:', 'Add Notification');
//        $instructions[] = 'Transport Layer: HTTP Post';
//        $instructions[] = 'Document type: Key value';
//        $instructions[] = 'Product List: <em>' . _digi3('Select the list you created in step %s', 4) . '</em>';
//        $instructions[] = 'HTTP URL: <em>' . _digi3('The notification URL from step %s', 1) . '</em>';
//
//        $tab = '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&bull; ';
//        $instructions[] = 'Notify for: <em>' . _digi3('Select the following entries') . "</em><br />
//${tab}Paid<br />
//${tab}Refunded<br />
//${tab}Partially Refunded<br />
//${tab}Chargeback<br />
//${tab}Returned direct debug<br />
//${tab}Test order<br />
//${tab}Subscription on hold<br />
//${tab}Subscription instated<br />
//${tab}Subscription deactivated";
//        $instructions[] = _digi3('Save your changes.');
//        $instructions[] = _digi3('<strong>Here in DigiMember</strong> enter the %s product id for the appropriate products.', 'Cleverbridge');

        return $instructions;
    }
}