<?php
/** @var ncore_Controller $this */

/**
 * @param array $usageArray
 * @return string
 */
function _short_code_usage($usageArray)
{
    $html = '';
    foreach ($usageArray as $tag => $description) {
        $html .= '
<div class="dm-formbox-item dm-row dm-middle-xs">
    <div class="dm-col-md-3 dm-col-sm-4 dm-col-xs-12 dm-color-coral">
        <tt>' . $tag . '</tt>
    </div>
    <div class="dm-col-md-8 dm-col-sm-8 dm-col-xs-10 dm-col-xs-offset-1 dm-col-sm-offset-0">
        <p class="dm-text">
            ' . $description . '
        </p>
    </div>
</div>
';
    }

    return '
<div class="dm-formbox-headline">
    ' . _digi('Usage') . '
</div>
<div class="dm-formbox-content">
    ' . $html . '
</div>
';
}

/**
 * @param array $contents
 * @return string
 */
function _short_code_preview($contents)
{
    $html = '';
    foreach ($contents as $description => $content) {
        $html .= '
<div class="dm-formbox-item dm-row dm-middle-xs">
    <div class="dm-col-md-3 dm-col-xs-12">
        <label>' . $description . '</label>
    </div>
    <div class="dm-col-md-9 dm-col-xs-12 dm-shortcode-preview">
        <iframe style="width: 100%; height: 100%; border: 0; min-height: 400px;" src="' . home_url('/?dm_shortcode_preview=' . $content) . '"></iframe>
    </div>
</div>
';
    }
    return '
<div class="dm-formbox-headline">
    ' . _digi('Preview') . '
</div>
<div class="dm-formbox-content">
    ' . $html . '
</div>
';
}

function _short_code($tag, $args = [])
{
    $html_args = '';
    foreach ($args as $key => $value) {
        $html_args .= " $key" . ($value ? "=$value" : '');
    }

    /** @var digimember_ShortCodeController $ncore_admin_shortcode_renderer */
    global $ncore_admin_shortcode_renderer;
    return $ncore_admin_shortcode_renderer->renderTag("$tag$html_args");
}

function _short_code_hl($tag)
{
    global $top_link;

    $tags = is_array($tag)
        ? $tag
        : [$tag];

    $html = '<div class="dm-row dm-middle-xs">';

    foreach ($tags as $tag) {
        $html .= "<a name='$tag'></a>";
    }

    foreach ($tags as $tag) {
        $html .= '<div class="dm-col-xs-11"><tt>[' . $tag . ']</tt></div><div class="dm-col-xs-1">' . $top_link . '</div>';
    }
    $html .= '</div>';

    return $html;
}

function _max_length($descriptions)
{
    $length = 20;

    foreach ($descriptions as $key => $value) {
        $length = max($length, strlen($key) + 2);
    }

    return $length;
}

/** @var array $descriptions */
/** @var digimember_ShortCodeController $renderer */
global $ncore_admin_shortcode_renderer;
$ncore_admin_shortcode_renderer = $renderer;

global $top_link;
ncore_api()->load->helper('html');
$top_title = _digi('To the top of the page');
$top_link = '
<a class="dm-btn dm-btn-primary dm-btn-icon" href="#top" title="' . $top_title . '">
  <span class="dm-icon icon-up-open dm-color-white"></span>
</a>
';

$bottom_icon = ncore_icon('bottom_link');

global $code_input_attributes;
$code_input_attributes = ['size' => _max_length($descriptions)];

?>

<div class="dm-tabs-content dm-form-instructions">
    <div class="dm-tabs-tab visible">
        <p class="dm-text">
            <?=_digi('The %s Plugin provides these shortcodes. You can use the shortcodes in any blog page text, post text or widget text. Just add the code to the text. It will be replaced by its content. Example: %s will be replaced by the number of sales.', $plugin, _short_code($tag_counter))?>
        </p>
        <p class="dm-text">
            <?=_digi('You can also add and configure all shortcodes on any particlar page (or post) through the editor. Just click the %s icon in any editor instance to add a shortcode.', $plugin)?>
        </p>
    </div>
</div>
<div class="dm-tabs-content dm-form-instructions">
    <div class="dm-tabs-tab visible">
        <div class="dm-formbox">
            <div class="dm-formbox-headline">
                <?=_digi( 'Shortcodes' )?>
            </div>
            <div class="dm-formbox-content">
                <?php foreach ($descriptions as $tag => $descr): ?>
                    <div class="dm-formbox-item dm-row dm-middle-xs">
                        <div class="dm-col-md-3 dm-col-sm-4 dm-col-xs-11">
                            <?=ncore_htmlTextInputCode( "[$tag]", $code_input_attributes )?>
                        </div>
                        <div class="dm-col-xs-1 dm-col-sm-1">
                            <a class="dm-btn dm-btn-primary dm-btn-icon" href="#<?=$tag?>" title="<?=_digi('Go to description of %s.',"[$tag]")?>">
                              <span class="dm-icon icon-down-open"></span>
                            </a>
                        </div>
                        <div class="dm-col-md-8 dm-col-sm-7 dm-col-xs-12">
                            <p class="dm-text">
                                <?=$descr?>
                            </p>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
</div>

    <br/> <br/>

<?php if (!empty($tag_licenses)): ?>
    <div class="dm-tabs-content">
        <div class="dm-tabs-tab visible">
            <div class="dm-formbox">
                <div class="dm-formbox-headline" style="font-size: 18px; padding-top: 0; padding-bottom: 0;">
                    <?= _short_code_hl($tag_licenses) ?>
                </div>
                <div class="dm-formbox-content">
                    <p class="dm-text"><?php _digie('Add a list of the user\'s DigiMember license keys to the page.') ?></p>
                </div>
            </div>
        </div>
    </div>
    <br/> <br/>
<?php endif; ?>


<?php if (!empty($tag_download_url)): ?>
    <div class="dm-tabs-content">
        <div class="dm-tabs-tab visible">
            <div class="dm-formbox">
                <div class="dm-formbox-headline" style="font-size: 18px; padding-top: 0; padding-bottom: 0;">
                    <?= _short_code_hl($tag_download_url) ?>
                </div>
                <div class="dm-formbox-content"><p class="dm-text"><?php _digie('Is replaced by the download URL for the DigiMember package:') ?></p>
                </div>
                <?= _short_code_usage([
                    _short_code($tag_download_url) => ncore_linkReplace(_digi('The <a>download URL</a> for the stable package.'), $html_download_url_1, false),
                    _short_code($tag_download_url, ['env' => 'test']) => ncore_linkReplace(_digi('The <a>download URL</a> for the test package. This package may not be stable and is not suited for production environments. Make this URL only available to special testers.'), $html_download_url_2, false),
                ]) ?>
            </div>
        </div>
    </div>
    <br/> <br/>
<?php endif; ?>


<?php if (!empty($tag_download_version)): ?>
    <div class="dm-tabs-content">
        <div class="dm-tabs-tab visible">
            <div class="dm-formbox">
                <div class="dm-formbox-headline" style="font-size: 18px; padding-top: 0; padding-bottom: 0;">
                    <?= _short_code_hl($tag_download_version) ?>
                </div>
                <div class="dm-formbox-content">
                    <p class="dm-text"><?php _digie('Is replaced by the version for the downloadable DigiMember package.') ?></p>
                </div>
                <?= _short_code_usage([
                    _short_code($tag_download_version) => _digi('Version of the stable package.', $html_download_url_1, false),
                    _short_code($tag_download_version, ['env' => 'test']) => _digi('Version of the test package.', $html_download_url_2, false),

                ]) ?>
            </div>
        </div>
    </div>
    <br/> <br/>
<?php endif; ?>


<?php if (!empty($tag_download_changelog)): ?>

    <div class="dm-tabs-content">
        <div class="dm-tabs-tab visible">
            <div class="dm-formbox">
                <div class="dm-formbox-headline" style="font-size: 18px; padding-top: 0; padding-bottom: 0;">
                    <?= _short_code_hl($tag_download_changelog) ?>
                </div>
                <div class="dm-formbox-content">
                    <p class="dm-text"><?php _digie('Is replaced by the changelog for the downloadable DigiMember package.') ?></p>
                </div>
                <?= _short_code_usage([
                    _short_code($tag_download_changelog) => _digi('Changelog of the stable package.', $html_download_url_1, false),
                    _short_code($tag_download_changelog, ['env' => 'test']) => _digi('Changelog of the test package.', $html_download_url_2, false),

                ]) ?>
            </div>
        </div>
    </div>
    <br/> <br/>
<?php endif; ?>

    <div class="dm-tabs-content">
        <div class="dm-tabs-tab visible">
            <div class="dm-formbox">
                <div class="dm-formbox-headline" style="font-size: 18px; padding-top: 0; padding-bottom: 0;">
                    <?= _short_code_hl($tag_login) ?>
                </div>
                <div class="dm-formbox-content">
                    <p class="dm-text"><?php _digie('If the user is logged out, this shortcode shows a login form box. If he is logged in, it shows an info box with the users avatar and name.') ?></p>
                </div>
                <?= _short_code_usage([
                    _short_code($tag_login) => _digi('After login the user is redirected to his product\'s start page.'),
                    _short_code($tag_login, ['stay_on_same_page' => '']) => _digi('After login the user stays on the same page.'),
                    _short_code($tag_login, ['redirect_if_logged_in' => '']) => _digi('If a logged in user visits the page, he is directed as if a has just logged in.'),
                    _short_code($tag_login, ['hidden_if_logged_in' => '']) => _digi('If the user is logged in, nothing is displayed.'),
                    _short_code($tag_login, ['url' => $demo_slug]) => _digi('After login the user is redirected to the URL %s.', $demo_slug),
                    _short_code($tag_login, ['img' => '"http://dom.com/img.jpg"']) => _digi('Use image button as form submit button. Please mind the double quotes (%s) before and after the URL.', '"'),
                ]) ?>
                <?= _short_code_preview([
                    _digi('If the user is logged out:') => 'html_login_box',
                    _digi('If the user is logged in:') => 'html_login_info',
                ]) ?>
            </div>
        </div>
    </div>

    <br/> <br/>

    <div class="dm-tabs-content">
        <div class="dm-tabs-tab visible">
            <div class="dm-formbox">
                <div class="dm-formbox-headline" style="font-size: 18px; padding-top: 0; padding-bottom: 0;">
                    <?= _short_code_hl($tag_logout) ?>
                </div>
                <div class="dm-formbox-content">
                    <p class="dm-text"><?php _digie('Use this e.g. to create a menu entry <em>logout</em>:') ?></p>
                    <ol class="dm-text">
                        <li><?php _digie('Create a page with title <em>logout</em>.'); ?></li>
                        <li><?php _digie('Add the short code %s to the page.', _short_code($tag_logout)); ?></li>
                        <li><?php _digie('Add the page to every product.') ?></li>
                    </ol>
                </div>
                <?= _short_code_usage([
                    _short_code($tag_logout) => _digi('After logout the user stays on the same page. This means, you can put content on a page containing the %s shortcode. If the user is already logged out, the %s shortcode is removed and the content is displayed.', $tag_logout),
                    _short_code($tag_logout, ['page' => 123]) => _digi('After logout the user is redirected to Wordpress page with the given id, e.g. 123.'),
                    _short_code($tag_logout, ['url' => $demo_slug]) => _digi('After logout the user is redirected to the given url, e.g. %s. This parameter is ignored, if the parameter <em>page</em> is given.', $demo_slug),
                ]) ?>
            </div>
        </div>
    </div>

    <br/><br/>

    <div class="dm-tabs-content">
        <div class="dm-tabs-tab visible">
            <div class="dm-formbox">
                <div class="dm-formbox-headline" style="font-size: 18px; padding-top: 0; padding-bottom: 0;">
                    <?= _short_code_hl($tag_account) ?>
                </div>

                <div class="dm-formbox-content">
                    <p class="dm-text"><?php _digie('Creates an edit form for the user\'s login name, email and password. If logged out, it shows nothing.') ?></p>
                </div>

                <?= _short_code_preview([
                    _digi('Example edit form:') . ' ' => 'html_account',
                ]) ?>

            </div>
        </div>
    </div>

    <br/><br/>

    <div class="dm-tabs-content">
        <div class="dm-tabs-tab visible">
            <div class="dm-formbox">
                <div class="dm-formbox-headline" style="font-size: 18px; padding-top: 0; padding-bottom: 0;">
                    <?= _short_code_hl($tag_autojoin); ?>
                </div>

                <div class="dm-formbox-content">
                    <p class="dm-text"><?php _digie('Use this short code to automatically create accounts for new autoresponder contacts.'); ?></p>

                    <ol class="dm-text">
                        <li><?php _digie('On page %s setup an autoresponder connection of type %s', $newsletter_menu, $autojoin_autoresponders) ?></li>
                        <li><?php _digie('Go to the autoresponder\'s home page and log in. Setup the optin process, so that the thank you page is a page of this Wordpress site (%s)', ncore_siteUrl()) ?></li>
                        <li><?php _digie('On the thank you page, use the shortcode %s. The shortcode will create the account and optionally display the login information.', _short_code($tag_autojoin)) ?></li>
                        <li><?php _digie('Text enclosed between %s and %s is only displayed, if an account was created.', _short_code($tag_autojoin), _short_code("/$tag_autojoin")) ?></li>
                        <li><?php _digie('You can use the shortcodes %s and %s to display username and password of the new account.', _short_code($tag_username), _short_code($tag_password)) ?></li>
                        <li><?php _digie('If you want to new user to automatically login, provide a link to your page with the GET-Parameter %s, e.g.: %s', '<tt>' . DIGIMEMBER_LOGINKEY_GET_PARAM . '=' . _short_code($tag_loginkey) . '</tt>', '<tt>' . ncore_addArgs(ncore_siteUrl(), [DIGIMEMBER_LOGINKEY_GET_PARAM => _short_code($tag_loginkey)], '&', false) . '</tt>') ?></li>
                        <li><?php _digie('If your autoresponder stores the contact\'s first and last names, you may use the short codes %s and %s.', _short_code($tag_firstname), _short_code($tag_lastname)) ?></li>
                    </ol>
                </div>
                <?= _short_code_usage([
                    _short_code($tag_autojoin, ['product' => '123,456']) => _digi('New users get both the products with ids 123 and 456. You may add any number of product ids seperated by commas.'),
                    _short_code($tag_autojoin, ['show_errors' => false]) => _digi('If the account creation fails, an error message describing the reason is displayed. Don\'t use this unless you want to investigate any problems.')]) ?>
            </div>
        </div>
    </div>

    <br/><br/>

    <div class="dm-tabs-content">
        <div class="dm-tabs-tab visible">
            <div class="dm-formbox">
                <div class="dm-formbox-headline" style="font-size: 18px; padding-top: 0; padding-bottom: 0;">
                    <?= _short_code_hl($tag_signup) ?>
                </div>
                <div class="dm-formbox-content">
                    <p class="dm-text"><?php _digie('Display a sign up form. New users automatically get a product. This is handled exactly like a purchase, i.e. the user will be signed up in the autoresponder if set up.') ?></p>
                </div>
                <?= _short_code_usage([
                    _short_code($tag_signup, ['product' => 123]) => _digi('Display a signup form. New users get the product with id 123.'),
                    _short_code($tag_signup, ['product' => '123,456']) => _digi('New users get both the products with ids 123 and 456. You may add any number of product ids seperated by commas.'),
                    _short_code($tag_signup, ['product' => 123, 'first_name' => '']) => _digi('Display a signup form with inputs for first name.'),
                    _short_code($tag_signup, ['product' => 123, 'first_name' => '', 'last_name' => '']) => _digi('Display a signup form with inputs for first and last name.'),
                    _short_code($tag_signup, ['product' => 123, 'login' => '']) => _digi('After submitting the form, the user is automatically logged in. Is is then redirected to the produt\'s first login page.'),
                    _short_code($tag_signup, ['product' => 123, 'name' => '', 'login' => '']) => _digi('Signup form with inputs for first and last name. User will be automatically logged in after signing up.'),
                    _short_code($tag_signup, ['product' => 123, 'img' => '"http://dom.com/img.jpg"']) => _digi('Use image button as form submit button. Please mind the double quotes (%s) before and after the url.', '"'),
                ]) ?>
                <?= _short_code_preview([
                    _digi('Without name fields:') => 'html_signup_1',
                    _digi('With name fields:') => 'html_signup_2',
                ]) ?>
            </div>
        </div>
    </div>

    <br/> <br/>


    <div class="dm-tabs-content">
        <div class="dm-tabs-tab visible">
            <div class="dm-formbox">
                <div class="dm-formbox-headline" style="font-size: 18px; padding-top: 0; padding-bottom: 0;">
                    <?= _short_code_hl($tag_products) ?>
                </div>
                <div class="dm-formbox-content">
                    <p class="dm-text"><?php _digie('List all products, the user has purchased.') ?></p>
                </div>
                <?= _short_code_preview([
                    _digi('Example product list:') . ' ' => 'html_products',
                ]) ?>
            </div>
        </div>
    </div>

    <br/> <br/>

    <div class="dm-tabs-content">
        <div class="dm-tabs-tab visible">
            <div class="dm-formbox">
                <div class="dm-formbox-headline" style="font-size: 18px; padding-top: 0; padding-bottom: 0;">
                    <?= _short_code_hl($tag_days_left) ?>
                </div>
                <div class="dm-formbox-content">
                    <p class="dm-text"><?php _digie('List the number of remaining days, the user may access the selected product.') ?></p>
                </div>
                <?= _short_code_usage([
                    _short_code($tag_days_left, ['product' => 123]) => _digi('Display the number of remaining days, the user may access the product with id 123.')]) ?>
            </div>
        </div>
    </div>

    <br/> <br/>

    <div class="dm-tabs-content">
        <div class="dm-tabs-tab visible">
            <div class="dm-formbox">
                <div class="dm-formbox-headline" style="font-size: 18px; padding-top: 0; padding-bottom: 0;">
                    <?= _short_code_hl($tag_op_locked_hint) ?>
                </div>
                <div class="dm-formbox-content">
                    <p class="dm-text"><?php _digie('Only needed for the live editor of OptimizePress2. Use this shortcode to display the hint, if the content is currently locked.') ?></p>
                </div>
            </div>
        </div>
    </div>

    <br/> <br/>

    <div class="dm-tabs-content">
        <div class="dm-tabs-tab visible">
            <div class="dm-formbox">
                <div class="dm-formbox-headline" style="font-size: 18px; padding-top: 0; padding-bottom: 0;">
                    <?= _short_code_hl($tag_op_show_always) ?>
                </div>
                <div class="dm-formbox-content">
                    <p class="dm-text"><?php _digie('For use with OptimizePress2 and the live editor: Use this short code to display the content even if the page is locked. This is useful for headlines.') ?></p>
                </div>
            </div>
        </div>
    </div>

    <br/> <br/>

    <div class="dm-tabs-content">
        <div class="dm-tabs-tab visible">
            <div class="dm-formbox">
                <div class="dm-formbox-headline" style="font-size: 18px; padding-top: 0; padding-bottom: 0;">
                    <?= _short_code_hl($tag_preview) ?>
                </div>
                <div class="dm-formbox-content">
                    <p class="dm-text"><?php _digie('Used for a free preview of the protected content. Everything before the short code is free to access. Everything after the short code is protected.') ?>
                    <h3><?php _digie('Example post') ?></h3>
                    <p>
                        <em><?php _digie('The beginning of your post is free content. Write some lines to raise the readers interest.') ?></em>
                    </p>
                    <p><?php echo "<strong>[$tag_preview]</strong>" ?></p>
                    <p>
                        <em><?php _digie('Everything after the short code is protected. If the user is not logged in or has no access to the product, this text is hidden. Instead the sales text entered in the product details is displayed.') ?></em>
                    </p>
                </div>
            </div>
        </div>
    </div>

    <br/><br/>

    <div class="dm-tabs-content">
        <div class="dm-tabs-tab visible">
            <div class="dm-formbox">
                <div class="dm-formbox-headline" style="font-size: 18px; padding-top: 0; padding-bottom: 0;">
                    <?= _short_code_hl($tag_counter) ?>
                </div>
                <div class="dm-formbox-content">
                    <p class="dm-text"><?php _digie('Provides a social proof counter for your sales.') ?></p>
                    <p class="dm-text"><?php _digie('Add e.g. this text to your sales page: "Already %s buyers trust in our product"', _short_code($tag_counter, ['start' => $example_offset])) ?></p>
                    <p class="dm-text"><?php _digie('This creates: "Already %s buyers trust in our product"', $html_counter_2) ?></p>
                    <p class="dm-text"><?php $offset = 10;
                        _digie('When you get more sales, the number is increased automatically. E.g. after %s additional sales, you get: ', $offset);
                        _digie('"Already %s buyers trust in our product"', $html_counter_2 + $offset) ?></p>
                </div>
                <?= _short_code_usage([
                    _short_code($tag_counter) => _digi('Show the total number of product sales (all products together) This shortcode creates now: %s', $html_counter_1),
                    _short_code($tag_counter, ['start' => $example_offset]) => _digi('If you have previous sales, you can add them by using the <em>start</em> parameter. This creates now: %s', $html_counter_2),
                    _short_code($tag_counter, ['product' => $example_product_id]) => _digi('To just count sales of a certain product, add the parameter <em>product</em> and set it to the product id (e.g. %s). This creates now: %s', $example_product_id, $html_counter_3),
                    _short_code($tag_counter, ['product' => $example_product_id, 'start' => $example_offset]) => _digi('You may also add a start value for the product. This creates now: %s', $html_counter_4),
                ]) ?>
            </div>
        </div>
    </div>

    <br/> <br/>


<?php if (!empty($tag_open) && !empty($tag_close)): ?>
    <div class="dm-tabs-content">
        <div class="dm-tabs-tab visible">
            <div class="dm-formbox">
                <div class="dm-formbox-headline" style="font-size: 18px; padding-top: 0; padding-bottom: 0;">
                    <?= _short_code_hl($tag_open, $tag_close) ?>
                </div>
                <div class="dm-formbox-content">
                    <p class="dm-text"><?php _digie('Displays the shortcode open resp. close braket.') ?></p>
                    <p class="dm-text"><?php _digie(_short_code($tag_open) . 'some_short_code' . _short_code($tag_close)) ?></p>
                </div>
            </div>
        </div>
    </div>
    <br/> <br/>
<?php endif; ?>


<?php if (!empty($tag_api)): ?>
    <div class="dm-tabs-content">
        <div class="dm-tabs-tab visible">
            <div class="dm-formbox">
                <div class="dm-formbox-headline" style="font-size: 18px; padding-top: 0; padding-bottom: 0;">
                    <?= _short_code_hl($tag_api) ?>
                </div>
                <div class="dm-formbox-content">
                    <p class="dm-text"><?php _digie('Displays the api reference.') ?></p>
                </div>
            </div>
        </div>
    </div>
    <br/> <br/>
<?php endif; ?>


<?php if (!empty($tag_api_version)): ?>
    <div class="dm-tabs-content">
        <div class="dm-tabs-tab visible">
            <div class="dm-formbox">
                <div class="dm-formbox-headline" style="font-size: 18px; padding-top: 0; padding-bottom: 0;">
                    <?= _short_code_hl($tag_api_version) ?>
                </div>
                <div class="dm-formbox-content">
                    <p class="dm-text"><?php _digie('Displays the API version.') ?></p>
                </div>
            </div>
        </div>
    </div>
    <br/> <br/>
<?php endif; ?>

<?php if (!empty($tag_sites)): ?>
    <div class="dm-tabs-content">
        <div class="dm-tabs-tab visible">
            <div class="dm-formbox">
                <div class="dm-formbox-headline" style="font-size: 18px; padding-top: 0; padding-bottom: 0;">
                    <?= _short_code_hl($tag_sites) ?>
                </div>
                <div class="dm-formbox-content">
                    <p class="dm-text"><?php _digie($descriptions[$tag_sites]) ?></p>
                </div>
            </div>
        </div>
    </div>
    <br/> <br/>
<?php endif; ?>

<?php if (!empty($tag_upgrade)): ?>
    <div class="dm-tabs-content">
        <div class="dm-tabs-tab visible">
            <div class="dm-formbox">
                <div class="dm-formbox-headline" style="font-size: 18px; padding-top: 0; padding-bottom: 0;">
                    <?= _short_code_hl($tag_upgrade) ?>
                </div>
                <div class="dm-formbox-content">
                    <p class="dm-text"><?php _digie($descriptions[$tag_upgrade]) ?></p>
                </div>
                <?= _short_code_usage([_short_code($tag_upgrade, ['id' => '1234-A1b2C3d4E5f6']) => _digi('Shows the URL for the Digistore24 upgrade order page.')]) ?>
            </div>
        </div>
    </div>
<?php endif; ?>