<?php

class ncore_UserSettingsData extends ncore_BaseData
{
    public function get( $name, $default='' )
    {
        $user_id = ncore_userId();

        return $this->getForUser( $user_id, $name, $default );
    }

    public function set( $name, $value )
    {
        $user_id = ncore_userId();

        $this->setForUser( $user_id, $name, $value );
    }

    public function getForUser( $user_id, $name, $default='' )
    {
        $user_id = $this->resolveUserid( $user_id );
        if (!$user_id) {
            return $default;
        }


        $where = array(
            'user_id' => $user_id,
            'name'    => $name,
        );

        $row = $this->getWhere( $where, 'id DESC' );

        if ($row)
        {
            return $row->value;
        }

        return $default;
    }

    public function setForUser( $user_id, $name, $value )
    {
        $user_id = $this->resolveUserid( $user_id );
        if (!$user_id) {
            return;
        }

        $where = array(
            'user_id' => $user_id,
            'name'    => $name,
        );

        $row = $this->getWhere( $where );
        if ($row)
        {
            if ($value)
            {
                $data = array( 'value' => $value );
                $this->update( $row->id, $data );
            }
            else
            {
                $this->delete( $row->id );
            }
        }
        elseif ($value)
        {
            $data = array(
                'user_id' => $user_id,
                'name'    => $name,
                'value'   => $value
            );
            $this->create( $data );
        }
    }

    public function dataType()
    {
        return NCORE_MODEL_DATA_TYPE_USER;
    }


    //
    // protected
    //
    protected function sqlBaseTableName()
    {
        return 'user_settings';
    }

    protected function sqlTableMeta()
    {
       $columns = array(
            'user_id' => 'string[127]',  
            'name'    => 'string[63]',
            'value'   => 'string[127]',
       );

       $indexes = array( 'user_id' );

       $meta = array(
        'columns' => $columns,
        'indexes' => $indexes,
       );

       return $meta;
    }

    protected function isUniqueInBlog() {

        return true;
    }
    
    private function resolveUserid( $email_or_wp_user_id )
    {
        if (is_numeric($email_or_wp_user_id)) {
            return $email_or_wp_user_id;
        }
        
        if (is_email( $email_or_wp_user_id ))
        {
            $user = get_user_by( 'email', $email_or_wp_user_id );
            return ncore_retrieve( $user, array( 'ID', 'id' ), $email_or_wp_user_id );
        }
        
        return ncore_userId( $email_or_wp_user_id );
    }

}