<?php

class ncore_SupportLogic extends ncore_BaseLogic
{
    function supportInfoKey()
    {
        $config = $this->api->load->model( 'logic/blog_config' );

        $key = $config->get( "support_info_key" );

        if (!$key)
        {
            $this->api->load->helper( 'string' );
            $key = ncore_randomString( 'alnum', 32 );

            $config->set( 'support_info_key', $key );
            $config->set( 'support_info_created', time() );
        }

        return $key;
    }

    function supportInfoUrl()
    {
        $key = $this->supportInfoKey();

        $base_url = $this->api->pluginUrl( 'ipn.php' );

        $args = array( 'dm_support_key' => $key );

        $url = ncore_addArgs( $base_url, $args );

        return $url;
    }

    function handleSupportInfoRequest()
    {
        $request_key = ncore_retrieve( $_GET, 'dm_support_key', false );
        if (!$request_key)
        {
            return;
        }

        $config = $this->api->load->model( 'logic/blog_config' );

        $is_enabled = $config->get( "support_info_enabled", false );
        if (!$is_enabled)
        {
            die( 'Support support url not enabled' );
        }

        $stored_key = $config->get( "support_info_key" );
        $key_valid = $stored_key && $request_key == $stored_key;
        if (!$key_valid)
        {
            die( 'Invalid support key' );
        }

        $this->dumpSupportInfo();

        exit(0);
    }

    private function dumpSupportInfo()
    {
        $plugin = $this->api->pluginDisplayName();
        $version = $this->api->pluginVersion();

        $wp_version = get_bloginfo('version');

        $config  = $this->api->load->model( 'logic/blog_config' );
        $api_key = $config->get( 'ds24_apikey', false );
        $api_key_id = 'none';
        if ($api_key)
        {
            $tokens = explode( '-', $api_key );
            $api_key_id = $tokens
                        ? $tokens[0] . '-xxxxxxxxxxxxxxxxxxxxx'
                        : "invalid (API key: $api_key)";
        }

        $site_url = site_url();

        $api_url = $this->api->licenseServerBaseUrl();

        echo "

<h1>DIGIMEMBER SUPPORT INFO</h1>

<p>This support info is for the technical digimember support team only.</p>

<p><hr /></p>

<h2>$plugin version: $version</h2>

<h2>Wordpress version: $wp_version</h2>

<h2>Digistore API key: $api_key_id</h2>

<h2>Site Url: $site_url</h2>

<h2>Remote Api Url: $api_url</h2>

<h2>Active Modules</h2>
<pre>
";


        print_r(wp_get_active_and_valid_plugins());
        print_r(get_plugins());

        echo '</pre><h2>Active Theme</h2><pre>';

        print_r( wp_get_theme() );

        echo '</pre>';


        $this->dumpData(  'config_store' );

        $this->dumpData(  'log' );

        $this->dumpData(  'ipn_in_log' );

        phpinfo();

        $this->postTest();

        $this->ds24Test();
    }

    /**
     * @param $text
     *
     * @return string
     */
    private function obfuscateEmail($text)
    {
        $pattern = "/[^@\s]*@[^@\s]*\.[^@\s]*/m";
        return preg_replace_callback($pattern, function($email) {
            foreach ($email as $key=>$value) {
                $em   = explode("@", $value);
                $name = implode(array_slice($em, 0, count($em) - 1), '@');
                $len  = floor(strlen($name) / 3);
                $email[$key] = substr($name, 0, $len) . str_repeat('*', $len * 2) . "@" . end($em);
            }
            return $email[0];
        }, $text);
    }

    private function dumpData( $model_name, $where = array(), $limit='0,1000', $order_by='id' )
    {
        $model = $this->api->load->model( "data/$model_name" );

        $all = $model->getAll( $where, $limit, $order_by );

        echo "<h2>Model: $model_name</h2><pre>";
        echo $this->obfuscateEmail(print_r($all, true));
        echo "</pre><p><hr /></p>";
    }

    private function ds24Test()
    {
        $model = $this->api->load->model( 'logic/digistore_connector' );
        $success = $model->testDs24ServerConnection();

        echo "<h1>Digistore24 api connection to remote Digistore24 server: ", ($success? 'ok' : 'ERROR' ), "</h1>";
    }

    private function postTest()
    {
        $action = 'connection_test';
        $args = array();

        $rpc = $this->api->load->library( 'rpc_api' );

        try
        {
            $result = $rpc->pluginApi( $action, $args );

            $success = ncore_retrieve( $result, 'status' ) == 'OK';

            $error_msg = '';
        }

        catch ( Exception $e )
        {
            $success = false;
            $error_msg = $e->getMessage();
        }

        echo "<h1>Post test to remote server: ", ($success? 'ok' : 'ERROR' );
        if ($error_msg)
        {
            echo " ($error_msg)";
        }
        echo "</h1>";
    }

}